package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.EstudioDocOS2;
import com.ejie.ab04b.model.TareaOS2;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0446s00DaoImpl generated by UDA, 14-Feb-2017 10:29:39.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class EstudioDocOS2DaoImpl implements EstudioDocOS2Dao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_046 IDTAREA046, t1.RESULTADO_046 RESULTADO046, t1.NOTAS_046 NOTAS046 FROM AB0446S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<EstudioDocOS2> rwMap = new RowMapper<EstudioDocOS2>() {
		public EstudioDocOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EstudioDocOS2(new TareaOS2(
					resultSet.getLong("IDTAREA046")),
					resultSet.getString("RESULTADO046"),
					resultSet.getString("NOTAS046"));
		}
	};

	private RowMapper<EstudioDocOS2> rwMapPK = new RowMapper<EstudioDocOS2>() {
		public EstudioDocOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EstudioDocOS2(new TareaOS2(
					resultSet.getLong("IDTAREA046")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0446s00 table.
	 * 
	 * ab0446s00 Ab0446s00 Ab0446s00
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @return the estudio doc OS 2
	 */
	public EstudioDocOS2 add(EstudioDocOS2 ab0446s00) {
		String query = "INSERT INTO AB0446S00 (ID_TAREA_046, RESULTADO_046) VALUES (?,?)";
		this.jdbcTemplate.update(query,
				ab0446s00.getTareaOS2().getIdTarea093(),
				ab0446s00.getResultado046());
		return ab0446s00;
	}

	/**
	 * Updates a single row in the Ab0446s00 table.
	 * 
	 * ab0446s00 Ab0446s00 Ab0446s00
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @return the estudio doc OS 2
	 */
	public EstudioDocOS2 update(EstudioDocOS2 ab0446s00) {
		String query = "UPDATE AB0446S00 SET RESULTADO_046=?, NOTAS_046=? WHERE ID_TAREA_046=?";
		this.jdbcTemplate.update(query, ab0446s00.getResultado046(), ab0446s00
				.getNotas046(), ab0446s00.getTareaOS2().getIdTarea093());
		return ab0446s00;
	}

	/**
	 * Finds a single row in the Ab0446s00 table.
	 * 
	 * ab0446s00 Ab0446s00 Ab0446s00
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @return the estudio doc OS 2
	 */
	@Transactional(readOnly = true)
	public EstudioDocOS2 find(EstudioDocOS2 ab0446s00) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS2DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_046 = ? ");

		List<EstudioDocOS2> ab0446s00List = this.jdbcTemplate.query(query
				.toString(), this.rwMap, ab0446s00.getTareaOS2()
				.getIdTarea093());
		return (EstudioDocOS2) DataAccessUtils.uniqueResult(ab0446s00List);
	}

	/**
	 * Removes a single row in the Ab0446s00 table.
	 * 
	 * ab0446s00 Ab0446s00
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 */
	public void remove(EstudioDocOS2 ab0446s00) {
		String query = "DELETE FROM AB0446S00 WHERE ID_TAREA_046=?";
		this.jdbcTemplate
				.update(query, ab0446s00.getTareaOS2().getIdTarea093());
	}

	/**
	 * Finds a list of rows in the Ab0446s00 table.
	 * 
	 * ab0446s00 Ab0446s00 jqGridRequestDto JQGridRequestDto List<Ab0446s00>
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EstudioDocOS2> findAll(EstudioDocOS2 ab0446s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS2DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0446s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EstudioDocOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0446s00 table using like.
	 * 
	 * ab0446s00 Ab0446s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0446s00>
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EstudioDocOS2> findAllLike(EstudioDocOS2 ab0446s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS2DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0446s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EstudioDocOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0446s00 table.
	 * 
	 * ab0446s00 Ab0446s00 Long
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EstudioDocOS2 ab0446s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0446S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0446s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0446s00 table using like.
	 * 
	 * ab0446s00 Ab0446s00 startsWith Boolean Long
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(EstudioDocOS2 ab0446s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0446S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0446s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0446s00 selected for rup_table.
	 * 
	 * ab0446s00 Ab0446s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Ab0446s00>>
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EstudioDocOS2>> reorderSelection(
			EstudioDocOS2 ab0446s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS2DaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0446s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, EstudioDocOS2.class, filterParamList,
				"ID_ESTUDIO_APERTURA_046");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EstudioDocOS2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab0446s00 searchParams Ab0446s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0446s00>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EstudioDocOS2>> search(EstudioDocOS2 filterParams,
			EstudioDocOS2 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS2DaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, EstudioDocOS2.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"ID_ESTUDIO_APERTURA_046");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EstudioDocOS2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0446s00 entity.
	 * 
	 * ab0446s00 Ab0446s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EstudioDocOS2 ab0446s00) {

		StringBuilder where = new StringBuilder(
				EstudioDocOS2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0446s00 != null && ab0446s00.getTareaOS2() != null
				&& ab0446s00.getTareaOS2().getIdTarea093() != null) {
			where.append(" AND t1.ID_TAREA_046 = ?");
			params.add(ab0446s00.getTareaOS2().getIdTarea093());
		}
		if (ab0446s00 != null && ab0446s00.getResultado046() != null) {
			where.append(" AND t1.RESULTADO_046 = ?");
			params.add(ab0446s00.getResultado046());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0446s00 entity.
	 * 
	 * ab0446s00 Ab0446s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0446s00
	 *            the ab 0446 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(EstudioDocOS2 ab0446s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EstudioDocOS2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0446s00 != null && ab0446s00.getTareaOS2() != null
				&& ab0446s00.getTareaOS2().getIdTarea093() != null) {
			where.append(" AND t1.ID_TAREA_046 = ?");
			params.add(ab0446s00.getTareaOS2().getIdTarea093());
		}
		if (ab0446s00 != null && ab0446s00.getResultado046() != null) {
			where.append(" AND UPPER(t1.RESULTADO_046) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0446s00.getResultado046().toUpperCase() + "%");
			} else {
				params.add("%" + ab0446s00.getResultado046().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RESULTADO_046 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
